import os
from datetime import datetime, timedelta

from travel.rasp.library.python.api_clients.sandbox import SandboxClient


def delete_inf_resources(resoruce_type, attrs=None, limit=10, skip_newer_than=None, dry_run=True, auth_token=None):
    """
    Удаляет ресурсы с ttl=inf (на самом деле ставит им ttl=1, т.к. прямого удаления нет)
    Удаляет limit самых старых ресурсов заданного типа.

    Пример проблемы: https://st.yandex-team.ru/RASPFRONT-9980
    """

    if skip_newer_than is None:
        skip_newer_than = (datetime.now() - timedelta(days=14)).strftime('%Y-%m-%d')

    if auth_token is None:
        auth_token = open(os.path.expanduser('~') +'/.sandbox_oauth').read()
    sandbox_api_url = 'https://sandbox.yandex-team.ru/api/v1.0/'
    sandbox_public_api = SandboxClient(host=sandbox_api_url, auth_token=auth_token)

    print(sandbox_public_api)
    resources = sandbox_public_api.get_resources(resoruce_type, limit, order='created', attrs=attrs)

    removed_total = 0
    for i, res in enumerate(resources):
        attrs = res['attributes']
        created = res['time']['created']
        print('{: <4}'.format(i), res['id'], created, attrs)

        if created > skip_newer_than:
            print('{} too new: {}. Skipped'.format(res['id'], created))
            continue
        # print(json.dumps(res, indent=4))
        if attrs.get('ttl') == 'inf':
            res_path = 'resource/{id}/attribute/{name}'.format(id=res['id'], name='ttl')
            print('removing', res_path)
            if not dry_run:
                sandbox_public_api.put(
                    res_path,
                    json={
                        "name": "ttl",
                        "value": "1"
                    }
                )
            removed_total += 1
        else:
            print('{} ttl != inf. Skipped'.format(res['id']))

    print('res total', len(resources))
    print('removed_total', removed_total)
