#!/usr/bin/env python2
# coding: utf8
from nginx_log_normalize_functions import nginx_log_normalize_uri

# Если в регулярке есть исключающие символы, заводим как кортеж, иначе просто как строку
PATHS = [
    r'Railway/V1/Search/TrainPricing',
    r'Railway/V1/Search/CarPricing',

    r'Order/V1/Reservation/Create',
    r'Order/V1/Reservation/ProlongReservation',
    r'Order/V1/Reservation/Confirm',
    r'Order/V1/Reservation/Cancel',

    r'Order/V1/Info/OrderInfo',
    r'Railway/V1/Reservation/UpdateBlanks',

    r'Order/V1/Reservation/Blank',
    r'Railway/V1/Reservation/BlankAsHtml',

    r'Railway/V1/Reservation/ElectronicRegistration',
    r'Order/V1/Reservation/AutoReturn',
    r'Order/V1/Reservation/ReturnAmount',

    r'Insurance/V1/Travel/Checkout',
    r'Insurance/V1/Travel/Pricing',
    r'Insurance/V1/Travel/Return',

    r'Railway/V1/Search/Schedule',
    r'Railway/V1/Search/TrainRoute',
]


def _get_paths_with_prefix(paths, prefix):
    return [r'{}{}'.format(prefix, p) for p in paths]


def nginx_log_normalize_path(uri):
    paths = _get_paths_with_prefix(PATHS, r'im/') + _get_paths_with_prefix(PATHS, r'im-test/')
    return nginx_log_normalize_uri(paths, uri, r'^/')
