version: "3.7"
services:
    mongodb:
        image: mongo:3.4.7
        container_name: "mongodb"
        environment:
          - MONGO_DATA_DIR=/data/db
          - MONGO_LOG_DIR=/dev/null
          - MONGODB_USER="rasp"
          - MONGODB_PASS="rasp"
        volumes:
          - ./data/mongodb:/data/db
        ports:
            - 27017:27017
        command: mongod --smallfiles --logpath=/dev/null # --quiet
    mysql:
        build:
            context: ./docker
            dockerfile: Dockerfile.mysql

        container_name: "mysql"
        restart: always
        environment:
            MYSQL_ROOT_PASSWORD: ''
            MYSQL_ALLOW_EMPTY_PASSWORD: '1'
            MYSQL_USER: 'rasp'
            MYSQL_PASS: 'rasp'
        volumes:
          - ./data/mysqldb:/var/lib/mysql
        ports:
          - 3306:3306
