# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os
import subprocess

import library.python.resource
from travel.library.recipe_utils.utils import Timer


description = 'docker-compose-step'


def _get_docker_env():
    """ Фиксим проблему https://paste.yandex-team.ru/772347 """
    docker_env = os.environ.copy()
    docker_env['DOCKER_API_VERSION'] = "1.37"
    docker_env['COMPOSE_API_VERSION'] = "1.37"

    return docker_env


def setup():
    with Timer('Preparing mysql-container'):
        os.mkdir('docker')
        mysql_dockerfile = library.python.resource.find('travel/rasp/common_recipe/docker/Dockerfile.mysql')
        with open('docker/Dockerfile.mysql', 'w') as f:
            f.write(mysql_dockerfile)
        mysql_conf = library.python.resource.find('travel/rasp/common_recipe/docker/rasp.cnf')
        with open('docker/rasp.cnf', 'w') as f:
            f.write(mysql_conf)

    with Timer('Preparing docker-compose..'):
        docker_compose = library.python.resource.find('travel/rasp/common_recipe/docker-compose.yml.rs')
        with open('docker-compose.yml', 'w') as f:
            f.write(docker_compose)

    with Timer('Runing docker-compose..'):
        subprocess.check_call(['docker-compose', 'up', '-d', '--build'], env=_get_docker_env())


def teardown():
    subprocess.check_call(['docker-compose', 'down'], env=_get_docker_env())
    subprocess.check_call(['docker-compose', 'rm'], env=_get_docker_env())
