# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os
import platform
import traceback

from library.python.testing.recipe import declare_recipe
from travel.rasp.library.common_recipe.library import compose, mongodb
from travel.library.recipes.library import mysql, mysql_schema
from travel.library.recipe_utils.utils import log, set_environ


def should_use_compose():
    return os.getenv('RASP_USE_DOCKER_COMPOSE') is not None


def get_steps():
    steps = []

    if not os.getenv('RASP_COMMON_RECIPE_SKIP_DB_START'):
        if should_use_compose():
            steps.extend([compose])
        else:
            steps.extend([mysql, mongodb])

    steps.append(mysql_schema.MysqlSchemaLoader())

    return steps


def start(argv):
    os.environ.setdefault('TRAVEL_RECIPE_MYSQL_DUMP_PATH', 'travel/rasp/common_recipe/schema_dump.gz')
    os.environ.setdefault('TRAVEL_MYSQL_RECIPE_TESTS_DB', 'rasp_tests')

    log('Platform: {}'.format(platform.platform()))

    for step in get_steps():
        log('Setting up {}'.format(step.description))
        try:
            step.setup()
        except Exception as ex:
            log('Exception', repr(ex), traceback.format_exc())
            raise ex
    log('Done.')


def stop(argv):
    for step in get_steps():
        try:
            log('Tearing down {}'.format(step.description))
            step.teardown()
        except Exception as ex:
            log('Failed tearing down step {} because of {}'.format(step.description, ex))


def main():
    declare_recipe(start, stop)
