package ru.yandex.travel.bus.model;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.buses.backend.proto.EBenefitType;
import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
public enum BusBenefitType {
    COFFEE(EBenefitType.BENEFIT_TYPE_COFFEE),
    CHARGER(EBenefitType.BENEFIT_TYPE_CHARGER),
    PRESS(EBenefitType.BENEFIT_TYPE_PRESS),
    TV(EBenefitType.BENEFIT_TYPE_TV),
    WI_FI(EBenefitType.BENEFIT_TYPE_WI_FI),
    NO_TICKET_REQUIRED(EBenefitType.BENEFIT_TYPE_NO_TICKET_REQUIRED),
    WC(EBenefitType.BENEFIT_TYPE_WC),
    CONDITIONER(EBenefitType.BENEFIT_TYPE_CONDITIONER),
    COMMON_AUDIO(EBenefitType.BENEFIT_TYPE_COMMON_AUDIO);

    private final EBenefitType protoValue;

    public static final EnumIndex<EBenefitType, BusBenefitType> BY_PROTO = EnumIndex.create(BusBenefitType.class,
            e -> e.protoValue);
}
