package ru.yandex.travel.bus.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.buses.backend.proto.EDocumentType;
import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
public enum BusDocumentType {
    RU_PASSPORT(EDocumentType.DOCUMENT_TYPE_RU_PASSPORT),
    RU_BIRTH_CERTIFICATE(EDocumentType.DOCUMENT_TYPE_RU_BIRTH_CERTIFICATE),
    RU_INTERNATIONAL_PASSPORT(EDocumentType.DOCUMENT_TYPE_RU_INTERNATIONAL_PASSPORT),
    RU_FOREIGN_PASSPORT(EDocumentType.DOCUMENT_TYPE_FOREIGN_PASSPORT),
    BY_PASSPORT(EDocumentType.DOCUMENT_TYPE_BY_PASSPORT);

    @Getter
    private final EDocumentType protoValue;

    public static final EnumIndex<EDocumentType, BusDocumentType> BY_PROTO = EnumIndex.create(BusDocumentType.class,
            e -> e.protoValue);
}
