package ru.yandex.travel.bus.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.buses.backend.proto.EGenderType;
import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
public enum BusGenderType {
    MALE(EGenderType.GENDER_TYPE_MALE),
    FEMALE(EGenderType.GENDER_TYPE_FEMALE);

    @Getter
    private final EGenderType protoValue;

    public static final EnumIndex<EGenderType, BusGenderType> BY_PROTO = EnumIndex.create(BusGenderType.class,
            e -> e.protoValue);
}
