package ru.yandex.travel.bus.model;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.buses.backend.proto.worker.EOrderStatus;
import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
public enum BusOrderStatus {
    BOOKED(EOrderStatus.OS_BOOKED),
    CANCELLED(EOrderStatus.OS_CANCELLED),
    CREATED(EOrderStatus.OS_CREATED),
    ERROR(EOrderStatus.OS_ERROR),
    PARTIAL_RETURNED(EOrderStatus.OS_PARTIAL_RETURNED),
    RETURNED(EOrderStatus.OS_RETURNED),
    SOLD(EOrderStatus.OS_SOLD);

    private final EOrderStatus protoValue;

    public static final EnumIndex<EOrderStatus, BusOrderStatus> BY_PROTO = EnumIndex.create(BusOrderStatus.class, e -> e.protoValue);
}
