package ru.yandex.travel.bus.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.buses.backend.proto.EPointKeyType;

@Data
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class BusPointInfo {
    private EPointKeyType type;
    private int id;
    private String pointKey;
    private String supplierDescription;
    private String title;
    private String address;
    private String timezone;
    private Double longitude;
    private Double latitude;
    private BusPointInfoSource source;

    public String getTitle() {
        if (Strings.isNullOrEmpty(title)) {
            return supplierDescription;
        }
        return title;
    }
}
