package ru.yandex.travel.bus.model;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.buses.backend.proto.ERegisterType;
import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
public enum BusRegisterType {
    COMPANY(ERegisterType.REGISTER_TYPE_COMPANY),
    ENTREPRENEUR(ERegisterType.REGISTER_TYPE_ENTREPRENEUR);

    private final ERegisterType protoValue;

    public static final EnumIndex<ERegisterType, BusRegisterType> BY_PROTO = EnumIndex.create(BusRegisterType.class,
            t -> t.protoValue);
}
