package ru.yandex.travel.bus.model;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import lombok.Data;
import lombok.NonNull;
import org.javamoney.moneta.Money;

import ru.yandex.travel.bus.service.BusesModelsHelpers;
import ru.yandex.travel.buses.backend.proto.ETicketType;

@Data
public class BusRide {
    private String rideId;
    private int supplierId;
    private BusPartner busPartner;
    private BusLegalEntity supplier;
    private String carrierCode;
    private BusLegalEntity carrier;

    private Instant departureTime;
    private Instant arrivalTime;
    private long duration;
    private BusPointInfo pointFrom;
    private BusPointInfo pointTo;
    private BusPointInfo titlePointFrom;
    private BusPointInfo titlePointTo;

    private Money price;
    private Money fee;
    private Money yandexFee;
    @NonNull private Map<ETicketType, Money> ticketTypeToFee = new HashMap<>();

    private Integer freeSeats;
    private Integer ticketLimit;
    private String bus;
    private String routeName;
    private String routeNumber;

    private List<BusBenefitType> benefits;
    private boolean canPayOffline;
    private boolean bookOnly;
    private boolean onlineRefund;
    private String refundConditions;

    public String getRouteName() {
        if (Strings.isNullOrEmpty(routeName) && titlePointFrom != null && titlePointTo != null) {
            return titlePointFrom.getTitle() + " - " + titlePointTo.getTitle();
        }
        return routeName;
    }

    @JsonIgnore
    public LocalDateTime getLocalDepartureTime() {
        String timezone = "UTC"; // because instant is already in timezone needed TODO BUSES-1608
        return BusesModelsHelpers.toLocalTime(getDepartureTime(), timezone);
    }

    @JsonIgnore
    public LocalDateTime getLocalArrivalTime() {
        String timezone = "UTC"; // because instant is already in timezone needed TODO BUSES-1608
        return BusesModelsHelpers.toLocalTime(getArrivalTime(), timezone);
    }
}
