package ru.yandex.travel.bus.model;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;
import org.javamoney.moneta.Money;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy.class)
public class BusRideHttp {
    private String id;
    private Integer supplierId;
    private String carrierCode;
    @Nullable
    private Long arrivalTime;
    private Long departureTime;
    private Point from;
    private Point to;
    private String fromDesc;
    private String toDesc;
    private Integer status;
    private Integer freeSeats;
    private String routeName;
    private Integer ticketLimit;
    private Boolean onlineRefund;
    private String refundConditions;
    private String[] bookFields;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private LegalInfo supplier;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String carrierName;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long duration;

    @JsonDeserialize(using = BusRideHttpPriceDeserializer.class)
    private Money price;

    @JsonDeserialize(using = BusRideHttpPriceDeserializer.class)
    private Money fee;

    @JsonDeserialize(using = BusRideHttpPriceDeserializer.class)
    private Money yandexFee;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String fromSupplierId;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String toSupplierId;

    @Data
    @JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy.class)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class LegalInfo {
        private String name;
        private String legalName;
        private String registerNumber;
        private String legalAddress;
        private String actualAddress;
        private Integer registerType;
        private String timetable;

        @JsonFormat(with = JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)
        private Integer ID;
    }

    @Data
    @JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy.class)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Point {
        @JsonInclude(JsonInclude.Include.NON_NULL)
        private Long id;

        @JsonInclude(JsonInclude.Include.NON_NULL)
        @JsonProperty("type")
        private Long type;
    }

    @Data
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Price {
        private Integer currency;
        private Long amount;
        private Integer precision;
    }
}
