package ru.yandex.travel.bus.model;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.IntNode;
import org.javamoney.moneta.Money;

import ru.yandex.travel.commons.proto.ECurrency;
import ru.yandex.travel.commons.proto.ProtoCurrencyUnit;

public class BusRideHttpPriceDeserializer extends StdDeserializer<Money> {

    public BusRideHttpPriceDeserializer() {
        this(null);
    }

    public BusRideHttpPriceDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public Money deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = p.getCodec().readTree(p);
        BigInteger amount = new BigInteger("0");
        if (node.hasNonNull("Amount")) {
            amount = ((IntNode) node.get("Amount")).bigIntegerValue();
        }
        int precision = ((IntNode) node.get("Precision")).intValue();

        ECurrency currency = ECurrency.forNumber(((IntNode) node.get("Currency")).intValue());
        ProtoCurrencyUnit currencyUnit = ProtoCurrencyUnit.fromProtoCurrencyUnit(currency);

        BigDecimal value = new BigDecimal(amount, precision);
        return Money.of(value, currencyUnit);
    }
}
