package ru.yandex.travel.bus.model;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.buses.backend.proto.worker.ETicketStatus;
import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
public enum BusTicketStatus {
    BOOKED(ETicketStatus.TS_BOOKED),
    CANCELLED(ETicketStatus.TS_CANCELLED),
    CREATED(ETicketStatus.TS_CREATED),
    ERROR(ETicketStatus.TS_ERROR),
    RETURNED(ETicketStatus.TS_RETURNED),
    SOLD(ETicketStatus.TS_SOLD);

    private final ETicketStatus protoValue;

    public static final EnumIndex<ETicketStatus, BusTicketStatus> BY_PROTO = EnumIndex.create(BusTicketStatus.class, e -> e.protoValue);
}
