package ru.yandex.travel.bus.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.buses.backend.proto.ETicketType;
import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
public enum BusTicketType {
    FULL(ETicketType.TICKET_TYPE_FULL),
    CHILD(ETicketType.TICKET_TYPE_CHILD),
    BAGGAGE(ETicketType.TICKET_TYPE_BAGGAGE);

    @Getter
    private final ETicketType protoValue;

    public static final EnumIndex<ETicketType, BusTicketType> BY_PROTO = EnumIndex.create(BusTicketType.class,
            e -> e.protoValue);
}
