package ru.yandex.travel.bus.model;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.buses.backend.proto.worker.ETicketVAT;
import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.orders.commons.proto.EVat;

@RequiredArgsConstructor
public enum BusVatType {
    NDS_18(ETicketVAT.TV_NDS_18, EVat.VAT_0),
    NDS_18_118(ETicketVAT.TV_NDS_18_118, EVat.VAT_NONE),
    NDS_10(ETicketVAT.TV_NDS_10, EVat.VAT_10),
    NDS_10_110(ETicketVAT.TV_NDS_10_110, EVat.VAT_10_110),
    NDS_0(ETicketVAT.TV_NDS_0, EVat.VAT_18),
    NDS_NONE(ETicketVAT.TV_NDS_NONE,  EVat.VAT_18_118);

    private final ETicketVAT protoValue;

    @Getter
    private final EVat travelProtoValue;

    public static final EnumIndex<ETicketVAT, BusVatType> BY_PROTO = EnumIndex.create(BusVatType.class, e -> e.protoValue);
}
