package ru.yandex.travel.bus.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.javamoney.moneta.Money;


@Data
public class BusesTicket {
    private String id;
    private BusTicketStatus status;
    private String blankUrl;
    private String code;
    private String series;
    private String number;
    private String barcode;
    private String platform;
    private Money price;
    private Money partnerFee;
    private Money yandexFee;
    private Money revenue;
    private BusVatType ticketVat;
    private BusVatType partnerFeeVat;
    private Integer ticketFiscalItemInternalId;
    private Integer partnerFeeFiscalItemInternalId;
    private Integer yandexFeeFiscalItemInternalId;
    private BusesPassenger passenger;

    private Money refundedPrice;

    @JsonIgnore
    public Money getTicketPrice() {
        return getPrice().subtract(getPartnerFee());
    }

    @JsonIgnore
    public Money getTotalPrice() {
        var result = getPrice();
        if (getYandexFee() != null) {
            result = result.add(getYandexFee());
        }
        return result;
    }
}
