package ru.yandex.travel.bus.service;

import io.opentracing.Tracer;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;

@Configuration
@EnableConfigurationProperties(BusesHttpApiServiceProperties.class)
public class BusesHttpApiServiceConfiguration {
    @Bean("BusesAhcWrapper")
    public AsyncHttpClientWrapper busesAhcWrapper(Tracer tracer) {
        AsyncHttpClient client = Dsl.asyncHttpClient(Dsl.config()
                .setThreadPoolName("ahcBusPool")
                .build());
        Logger logger = LoggerFactory.getLogger(BusesHttpApiService.class);
        return new AsyncHttpClientWrapper(client, logger, "buses", tracer, null);
    }

    @Bean("BusesHttpApiService")
    public BusesHttpApiService busesHttpApiService(
            @Qualifier("BusesAhcWrapper") AsyncHttpClientWrapper client,
            BusesHttpApiServiceProperties properties
    ) {
        return new BusesHttpApiService(client, properties);
    }
}
