package ru.yandex.travel.bus.service;

import javax.validation.constraints.NotEmpty;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@Validated
@ConfigurationProperties(value = "buses-http-service")
public class BusesHttpApiServiceProperties {
    @NotEmpty
    private String baseUrl;
    @NotEmpty
    private String calendarPath;
    @NotEmpty
    private String searchPath;
    @NotEmpty
    private String pointsPath;
}
