package ru.yandex.travel.bus.service

import com.google.protobuf.Message

import ru.yandex.travel.buses.backend.proto.api.CreateRideOfferRequest
import ru.yandex.travel.buses.backend.proto.api.CreateRideOfferResponse
import ru.yandex.travel.buses.backend.proto.api.GetOfferRequest
import ru.yandex.travel.buses.backend.proto.api.GetOfferResponse
import ru.yandex.travel.buses.backend.proto.worker.TBookRequest
import ru.yandex.travel.buses.backend.proto.worker.TBookResponse
import ru.yandex.travel.buses.backend.proto.worker.TCancelBookingRequest
import ru.yandex.travel.buses.backend.proto.worker.TCancelBookingResponse
import ru.yandex.travel.buses.backend.proto.worker.TConfirmRequest
import ru.yandex.travel.buses.backend.proto.worker.TConfirmResponse
import ru.yandex.travel.buses.backend.proto.worker.TRefundInfoRequest
import ru.yandex.travel.buses.backend.proto.worker.TRefundInfoResponse
import ru.yandex.travel.buses.backend.proto.worker.TRefundRequest
import ru.yandex.travel.buses.backend.proto.worker.TRefundResponse
import java.util.concurrent.CompletableFuture

interface BusesService {
    fun rideDetails(request: CreateRideOfferRequest): CompletableFuture<CreateRideOfferResponse>
    fun getOffer(request: GetOfferRequest): CompletableFuture<GetOfferResponse>
    fun book(request: TBookRequest, testContextMsg: Message?): TBookResponse
    fun confirm(request: TConfirmRequest): TConfirmResponse
    fun cancelBooking(request: TCancelBookingRequest): TCancelBookingResponse
    fun refundInfo(request: TRefundInfoRequest): TRefundInfoResponse
    fun refund(request: TRefundRequest): TRefundResponse
}
