package ru.yandex.travel.bus.service;

import lombok.Getter;

import ru.yandex.travel.commons.proto.EErrorCode;
import ru.yandex.travel.workflow.exceptions.RetryableException;

public class BusesServiceRetryableException extends RetryableException {

    @Getter
    private final EErrorCode code;

    public BusesServiceRetryableException(Throwable cause) {
        super(cause);
        this.code = EErrorCode.EC_UNAVAILABLE;
    }

    public BusesServiceRetryableException(EErrorCode code, String message) {
        super(message);
        this.code = code;
    }
}
