package ru.yandex.travel.suburban.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

@Data
@Builder
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public class AeroexpressReservation {
    // initial
    private Integer menuId;
    private Integer orderType;
    private LocalDate date;

    // from partner
    private Long orderId;
    private Long ticketId;
    private String ticketUrl;
    private String tariff;
    private String stDepart;
    private String tripDate;
    private String validUntil;

    @JsonIgnore
    public String getTicketBody() {
        return ticketUrl == null ? null : ticketUrl + "&type=pdf";
    }
}
