package ru.yandex.travel.suburban.model;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

@Data
@Builder(toBuilder = true)
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public class MovistaReservation {
    // initial
    private LocalDate date;
    private Integer stationFromExpressId;
    private Integer stationToExpressId;
    private Integer fareId;
    private WicketDevice wicket;

    // from partner
    private Integer orderId;
    private Integer ticketNumber;
    private String ticketBody;

    @JsonIgnore
    public boolean hasValidator() {
        return wicket == null || wicket.type == WicketType.VALIDATOR;
    }
}
