package ru.yandex.travel.suburban.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Singular;
import lombok.extern.jackson.Jacksonized;

@Data
@Builder
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public class SuburbanDicts {
    @Singular
    private List<Station> stations;

    @Data
    @Builder
    @Jacksonized
    @AllArgsConstructor
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Station {
        private int raspID;
    }
}
