package ru.yandex.travel.suburban.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

/*
Описывает различные варианты взаимодействия пользователя с билетом.
От этого зависит логика в пользовательских интерфейсах - и ожидаемые поля для этой логики.
*/
@RequiredArgsConstructor
public enum SuburbanTicketFlow implements ValueBasedEnum<String> {
    SIMPLE("simple"),  // просто отображение штрих-кода на экране
    VALIDATOR("validator"),  // флоу с валидатором (сканируем qr с валидатора, только потом получаем штрихкод)
    AEROEXPRESS("aeroexpress");  // отображение штрих-кода на экране, Аэроэкспресс-style

    @Getter
    @JsonValue
    private final String value;

    private static final EnumIndex<String, SuburbanTicketFlow> INDEX = EnumIndex.create(SuburbanTicketFlow.class);

    @JsonCreator
    public static SuburbanTicketFlow forValue(String value) {
        return INDEX.getByValue(value);
    }
}
