package ru.yandex.travel.suburban.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;


public enum WicketType implements ValueBasedEnum<String> {
    TURNSTILE("turnstile"),
    VALIDATOR("validator");

    private final String value;

    private static final EnumIndex<String, WicketType> INDEX = EnumIndex.create(WicketType.class);

    WicketType(String value) {
        this.value = value;
    }

    @Override
    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static WicketType forValue(String value) {
        return INDEX.getByValue(value);
    }
}
