package ru.yandex.travel.suburban.partners;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;


@RequiredArgsConstructor
public enum SuburbanCarrier implements ValueBasedEnum<String> {
    CPPK("cppk"),
    SZPPK("szppk"),
    MTPPK("mtppk"),
    BASHPPK("bashppk"),
    SODRUZHESTVO("sodruzhestvo"),
    AEROEXPRESS("aeroexpress"),
    @Deprecated
    UNKNOWN("unknown");

    @Getter
    @JsonValue
    private final String value;

    private static final EnumIndex<String, SuburbanCarrier> INDEX = EnumIndex.create(SuburbanCarrier.class);

    @JsonCreator
    public static SuburbanCarrier forValue(String value) {
        return INDEX.getByValue(value);
    }
}
