package ru.yandex.travel.suburban.partners;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;


@RequiredArgsConstructor
public enum SuburbanProvider implements ValueBasedEnum<String> {
    MOVISTA("movista"),
    IM("im"),
    AEROEXPRESS("aeroexpress");

    @Getter
    @JsonValue
    private final String value;

    private static final EnumIndex<String, SuburbanProvider> INDEX = EnumIndex.create(SuburbanProvider.class);

    @JsonCreator
    public static SuburbanProvider forValue(String value) {
        return INDEX.getByValue(value);
    }
}
