package ru.yandex.travel.suburban.partners;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

/*
Описывает коды различных пресетов настроек для формирования штрих-кода билета в приложении
*/
@RequiredArgsConstructor
public enum SuburbanTicketBarcodePreset implements ValueBasedEnum<String> {
    PDF417_CPPK("PDF417_cppk"),
    PDF417_SZPPK("PDF417_szppk"),
    AZTEC_MTPPK("Aztec_mtppk"),
    NO_BARCODE("No_barcode");

    @Getter
    @JsonValue
    private final String value;

    private static final EnumIndex<String, SuburbanTicketBarcodePreset> INDEX = EnumIndex.create(SuburbanTicketBarcodePreset.class);

    @JsonCreator
    public static SuburbanTicketBarcodePreset forValue(String value) {
        return INDEX.getByValue(value);
    }
}
