package ru.yandex.travel.suburban.partners.aeroexpress;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.suburban.partners.aeroexpress.model.RequestTickets3;
import ru.yandex.travel.suburban.partners.aeroexpress.model.RequestTicketsResponse;
import ru.yandex.travel.suburban.partners.aeroexpress.model.TicketHistory2;
import ru.yandex.travel.suburban.partners.aeroexpress.model.VersionInfoResponse;

public interface AeroexpressClient {

    VersionInfoResponse versionInfo();

    RequestTicketsResponse requestTickets(RequestTickets3 request);

    void payOrder(Long providerOrderId);

    TicketHistory2 getOrderTickets(Long providerOrderId);

    byte[] downloadTicket(String ticketPdfUrl);

    @RequiredArgsConstructor
    @Getter
    enum Endpoint {
        VERSION_INFO("getVersionInfo"),
        REQUEST_TICKETS("requestTickets3"),
        PAY_ORDER("payOrder"),
        GET_ORDER_TICKETS("getOrderTickets");

        private final String path;

        public static Set<String> endpointsSet() {
            return Arrays.stream(values())
                    .map(Enum::toString)
                    .collect(Collectors.toSet());
        }
    }
}
