package ru.yandex.travel.suburban.partners.movista;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

public interface MovistaClient {
    MovistaModel.OrderResponse book(MovistaModel.BookRequest request);

    MovistaModel.OrderResponse confirm(MovistaModel.ConfirmRequest request);

    MovistaModel.OrderResponse orderInfo(MovistaModel.OrderInfoRequest request);

    default MovistaModel.OrderResponse orderInfo(Integer orderId) {
        return orderInfo(MovistaModel.OrderInfoRequest.builder().orderId(orderId).build());
    }

    byte[] getBlankPdf(MovistaModel.BlankPdfRequest request);

    default byte[] getBlankPdf(Integer orderId) {
        return getBlankPdf(MovistaModel.BlankPdfRequest.builder().orderId(orderId).build());
    }

    @RequiredArgsConstructor
    @Getter
    enum Endpoint {
        BOOK("/api/v1/book"),
        CONFIRM("/api/v1/confirm"),
        INFO("/api/v1/info"),
        BLANK_PDF("/api/v1/blank/pdf");

        private final String path;

        public static Set<String> endpointsSet() {
            return Arrays.stream(values())
                    .map(Enum::toString)
                    .collect(Collectors.toSet());
        }
    }
}
