package ru.yandex.travel.suburban.partners.movista;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@ToString
@RequiredArgsConstructor
public enum MovistaErrorCode implements ValueBasedEnum<Integer> {
    // https://st.yandex-team.ru/RASPFRONT-8980#601aa361ca7fc23ec61a085d
    USER_UNAUTHORIZED(1000, 401, "Ошибка авторизации пользователя"),
    TOKEN_ERROR(1001, 403, "Токен не найден"),
    CARRIER_TIMEOUT(1002, 408, "Таймаут при запросе к перевозчику, повторите позднее"),
    DEP_STATION_REQUIRED(1010, 400, "Не передана станция отправления"),
    DEST_STATION_REQUIRED(1011, 400, "Не передана станция прибытия"),
    DEP_DATE_REQUIRED(1012, 400, "Не передана дата отправления"),
    FARE_REQUIRED(1013, 400, "Не передан тариф"),
    FARE_INVALID(1014, 400, "Тариф не соответствует направлению поездки	Некорректный тариф"),
    DATE_INVALID(1015, 400, "Ошибка формата даты	Некорректный формат даты"),
    ORDER_ID_REQUIRED(1016, 400, "Не передан идентификатор заказа при запросе подтверждения"),
    TX_ID_REQUIRED(1017, 400, "Не передан идентификатор транзакции при запросе подтверждения"),
    ORDER_TWOWAY_UNSUPPORTED(1019, 400, "Продажа билетов туда-обратно не поддерживается"),
    FARE_TSOPPD_NOT_FOUND(1020, 400, "Тариф не найден у перевозчика"),
    ORDER_PAST_DATE_UNSUPPORTED(1021, 400, "Продажа билета на истекшую дату невозможна"),
    ORDER_STATUS_INVALID(1118, 400, "Ошибочный статус заказа	Некорректный статус заказа"),
    DEP_STATION_NOT_FOUND(1101, 404, "Станция отправления не найдена"),
    DEST_STATION_NOT_FOUND(1102, 404, "Станция прибытия не найдена"),
    ORDER_NOT_FOUND(1103, 404, "Заказ не найден"),
    SERVER_ERROR(1500, 503, "Ошибка сервера	Сервис временно недоступен"),
    PROVIDER_ERROR(2000, 503, "Ошибка на стороне провайдера, повторите позднее");

    private final Integer code;
    private final int httpCode;
    private final String description;

    private static final EnumIndex<Integer, MovistaErrorCode> INDEX = EnumIndex.create(MovistaErrorCode.class);

    @Override
    @JsonValue
    public Integer getValue() {
        return code;
    }

    @JsonCreator
    public static MovistaErrorCode forValue(Integer code) {
        return INDEX.getByValue(code);
    }
}
