package ru.yandex.travel.suburban.partners.movista;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.commons.logging.masking.PersonalData;


public class MovistaModel {
    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    @Jacksonized
    public static class BookRequest {
        LocalDate date;
        Integer fromExpressId;
        Integer toExpressId;
        Integer fareId;
        String email;
        String phone;

        // optional fields https://st.yandex-team.ru/RASPFRONT-9204
        @PersonalData
        String docNumber;
        String docType;
        @PersonalData
        String firstName;
        @PersonalData
        String lastName;
        @PersonalData
        String middleName;
    }

    @Data
    @Builder
    @Jacksonized
    public static class ConfirmRequest {
        Integer orderId;
        String txId;
    }

    @Data
    @Builder
    @Jacksonized
    public static class OrderInfoRequest {
        Integer orderId;
    }

    @Data
    @Builder(toBuilder = true)
    @Jacksonized
    public static class OrderResponse {
        Integer orderId;
        MovistaOrderStatus status;
        Integer type;  // сейчас всегда == 1, означает "билет в одну сторону"

        LocalDate travelDate;          // дата поездки: 2021-04-12
        LocalDateTime validDate;       // время, до которого бронь валидна: 2021-04-13T02:59:59
        LocalDateTime confirmDate;     // время подтверждения: 2021-04-07T13:20:27
        LocalDateTime activationDate;  // время активации

        Integer fareId;
        String farePlan;               // "Пассажирский"
        String ticketBody;
        Integer ticketNumber;
        String ticketType;             // "Разовый полный"
        String instruction;            // "MID2Tutorial"
        BigDecimal price;              // 72.0000

        Integer fromExpressId;         // 2000055
        String fromStationName;        // "ОДИНЦОВО"
        Integer toExpressId;           // 2000006
        String toStationName;          // "МОСКВА (Белорусский вокзал)"

        String provider;               // АО «ЦЕНТРАЛЬНАЯ ППК»
        String inn;                    // 7705705370
        String phone;                  // 88007750000

        String receiptLink;
        String refundReceiptLink;
        LocalDateTime refundDate;
        BigDecimal refundSum;
    }

    @Data
    @Builder
    @Jacksonized
    public static class ErrorResponse {
        MovistaErrorCode code;  //   1016
        String result;          //   "ERROR"
        String message;         //   "Не передан ID заказа"
        String rid;             //   "api-6k.test-9-210205-164011-073"
    }

    @Data
    @Builder
    @Jacksonized
    public static class BlankPdfRequest {
        Integer orderId;
    }
}

