package ru.yandex.travel.suburban.partners.movista;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum MovistaOrderStatus {
    // https://st.yandex-team.ru/RASPFRONT-8980#601aa361ca7fc23ec61a085d
    CREATED("created"),
    PENDING("pending"),
    CANCELLED("cancelled"),
    CONFIRMED("confirmed"),
    EXPIRED("expired"),
    REFUNDED("refunded"),

    // Это статус, который возникает из-за того, что запрос не получил ответа от поставщика.
    // При этом у поставщика нет метода опроса статуса заказа.
    // Их следует приравнивать для агента к cancelled
    FAILED("failed");

    @JsonValue
    private final String value;
}
