RECURSE(src/test)

JAVA_LIBRARY()
JDK_VERSION(11)
OWNER(g:rasp-back)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/main/resources **/*)
JAVA_SRCS(SRCDIR ${BINDIR}/generated **/*)

INCLUDE(${ARCADIA_ROOT}/travel/library/java/dependencies.inc)
INCLUDE(${ARCADIA_ROOT}/travel/library/java/lombok.inc)

PEERDIR(
    travel/library/java/commons

    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jdk8
    contrib/java/com/sun/xml/ws/jaxws-ri
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/org/asynchttpclient/async-http-client
)

SET(
    WSIMPORT_ARGS
    -keep -s ${BINDIR}/generated
    -p ru.yandex.travel.suburban.partners.aeroexpress.model
    -Xnocompile
    -extension -B-XautoNameResolution
    -B-Xsetters -B-Xsetters-mode=direct
    -B-XReplacePrimitives
    -B-XJsr303Annotations
)

RUN_JAVA_PROGRAM(
    WsImport
    ${WSIMPORT_ARGS}
    src/main/resources/aeroexpress.wsdl
    IN src/main/resources/aeroexpress.wsdl
    OUT_DIR generated
    CLASSPATH devtools/maven-plugins/wsimport/tool
)

DEPENDENCY_MANAGEMENT(
    contrib/java/com/sun/xml/ws/jaxws-ri/2.3.2
)

NO_LINT()
END()
