package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum AdditionalPlaceRequirements {
    // Не задано
    NO_VALUE("NoValue"),
    // Место матери и ребенка до 1 года. Действует для поездов САПСАН
    MOTHER_AND_BABY_PLACES("MotherAndBabyPlaces"),
    // Места для пассажиров с детьми. Действует для поездов САПСАН
    WITH_BABY_PLACES("WithBabyPlaces"),
    // Места для пассажиров с животными. Действует для поездов САПСАН, АЛЛЕГРО
    WITH_PETS_PLACES("WithPetsPlaces"),
    // Для поездов САПСАН, АЛЛЕГРО - обычное место не у стола. Для поездов ЛАСТОЧКА - неоткидное место.
    USUAL("Usual"),
    // У стола (обычные места). Действует для поездов САПСАН, АЛЛЕГРО
    USUAL_NEAR_THE_TABLE("UsualNearTheTable"),
    // Любое у стола (включая рядом с местами для пассажиров с животными, детской площадкой и т.д). Действует для поездов САПСАН, АЛЛЕГРО
    ANY_NEAR_THE_TABLE("AnyNearTheTable"),
    // Любое не у стола (включая рядом с местами для пассажиров с животными, детской площадкой и т.д). Действует для поездов САПСАН, АЛЛЕГРО
    ANY_NOT_NEAR_THE_TABLE("AnyNotNearTheTable"),
    // Рядом с детской площадкой. Действует для поездов АЛЛЕГРО
    NEAR_THE_PLAYGROUND("NearThePlayground"),
    // Рядом с детской площадкой и не у стола. Действует для поездов АЛЛЕГРО
    NEAR_THE_PLAYGROUND_AND_NOT_THE_TABLE("NearThePlaygroundAndNotTheTable"),
    // Рядом с детской площадкой и у стола. Действует для поездов АЛЛЕГРО
    NEAR_THE_PLAYGROUND_AND_THE_TABLE("NearThePlaygroundAndTheTable"),
    // Рядом с местами для пассажиров с животными. Действует для поездов АЛЛЕГРО
    NEAR_THE_PLACES_WITH_PETS("NearThePlacesWithPets"),
    // Откидное место. Действует для поездов ЛАСТОЧКА
    FOLDABLE_PLACE("FoldablePlace"),
    // Место по ходу поезда. Действует для поездов САПСАН, ЛАСТОЧКА
    FORWARD("Forward"),
    // Место против хода поезда. Действует для поездов САПСАН, ЛАСТОЧКА
    BACKWARD("Backward"),
    // Места в ряду, рядом с которыми есть окно. Действует для поездов САПСАН
    NEAR_WINDOW("NearWindow"),
    // Неоткидное место. Действует для поездов ЛАСТОЧКА, СТРИЖ
    UNFOLDABLE_PLACE("UnfoldablePlace"),
    // Место у стола против хода. Действует для поездов САПСАН, ЛАСТОЧКА
    NEAR_THE_TABLE_AND_BACKWARD("NearTheTableAndBackward"),
    // Место у стола по ходу. Действует для поездов САПСАН, ЛАСТОЧКА
    NEAR_THE_TABLE_AND_FORWARD("NearTheTableAndForward"),
    // Место не у стола против хода. Действует для поездов САПСАН, ЛАСТОЧКА
    WITHOUT_TABLE_AND_BACKWARD("WithoutTableAndBackward"),
    // Место не у стола по ходу. Действует для поездов САПСАН, ЛАСТОЧКА
    WITHOUT_TABLE_AND_FORWARD("WithoutTableAndForward"),
    // Место без окна против хода. Действует для поездов САПСАН, ЛАСТОЧКА
    WITHOUT_WINDOW_AND_BACKWARD("WithoutWindowAndBackward"),
    // Место без окна по ходу. Действует для поездов САПСАН, ЛАСТОЧКА
    WITHOUT_WINDOW_AND_FORWARD("WithoutWindowAndForward"),
    // Одиночное по ходу. Действует для поездов САПСАН, ЛАСТОЧКА
    SINGLE_AND_FORWARD("SingleAndForward"),
    // У туалета. Действует для поездов ЛАСТОЧКА
    NEAR_RESTROOM("NearRestroom"),
    // У туалета против хода. Действует для поездов ЛАСТОЧКА
    NEAR_RESTROOM_AND_BACKWARD("NearRestroomAndBackward"),
    // У туалета по ходу. Действует для поездов ЛАСТОЧКА
    NEAR_RESTROOM_AND_FORWARD("NearRestroomAndForward"),
    // Не у стола, без окна. Действует для поездов ЛАСТОЧКА
    NO_TABLE_AND_NO_WINDOW("NoTableAndNoWindow");

    private final String value;

    @JsonCreator
    public static AdditionalPlaceRequirements fromString(String val) {
        for (AdditionalPlaceRequirements candidate : AdditionalPlaceRequirements.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum AdditionalPlaceRequirements", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
