package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum CabinGenderKind {
    NO_VALUE("NoValue"), // Не указан
    MIXED("Mixed"), // Смешанное
    MALE("Male"), // Мужское
    FEMALE("Female"); // Женское

    private final String value;

    @JsonCreator
    public static CabinGenderKind fromString(String val) {
        for (CabinGenderKind candidate : CabinGenderKind.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum CabinGenderKind", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
