package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum CabinPlaceDemands {
    NO_VALUE("NoValue"), // Не важно
    IN_ONE_CABIN("InOneCabin"), // В одном купе
    NO_SIDE_PLACES("NoSidePlaces"), // Не боковые
    IN_ONE_COMPARTMENT("InOneCompartment"); // В одном отсеке

    private final String value;

    @JsonCreator
    public static CabinPlaceDemands fromString(String val) {
        for (CabinPlaceDemands candidate : CabinPlaceDemands.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum CabinPlaceDemands", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
