package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum CarStorey {
    NO_VALUE("NoValue"),
    FIRST("First"),
    SECOND("Second");

    private final String value;

    @JsonCreator
    public static CarStorey fromString(String val) {
        for (CarStorey candidate : CarStorey.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum CarStorey", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
