package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum CarType {
    UNKNOWN("Unknown", null), // Не определен
    SHARED("Shared", "общий"), // Общий
    SOFT("Soft", "мягкий"), // Люкс
    LUXURY("Luxury", "СВ"), // СВ
    COMPARTMENT("Compartment", "купе"), // Купе
    RESERVED_SEAT("ReservedSeat", "плацкарт"), // Плацкарт
    SEDENTARY("Sedentary", "сидячий"), // Сидячий
    BAGGAGE("Baggage", null); // Багажный


    private final String value;

    @Getter
    private final String title;

    @JsonCreator
    public static CarType fromString(String val) {
        for (CarType candidate : CarType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum CarType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
