package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum DocumentType {
    RUSSIAN_PASSPORT("RussianPassport"),
    BIRTH_CERTIFICATE("BirthCertificate"),
    RUSSIAN_INTERNATIONAL_PASSPORT("RussianForeignPassport"),
    FOREIGN_DOCUMENT("ForeignPassport"),
    SAILOR_PASSPORT("SailorPassport"),
    MILITARY_CARD("MilitaryCard");

    private final String value;

    @JsonCreator
    public static DocumentType fromString(String val) {
        for (DocumentType candidate : DocumentType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum DocumentType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
