package ru.yandex.travel.train.model;

import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;

@RequiredArgsConstructor
public enum ErrorMessageCode {
    TRY_LATER(ErrorCode.TRY_LATER),
    REBOOKING_FAILED(ErrorCode.REBOOKING_FAILED),
    INVALID_BONUS_CARD(ErrorCode.INVALID_BONUS_CARD),
    PARTNER_ERROR(ErrorCode.UNKNOWN_PARTNER_ERROR);

    private final ErrorCode errorCode;

    public final static EnumIndex<ErrorCode, ErrorMessageCode> BY_ERROR_CODE =
            EnumIndex.create(ErrorMessageCode.class, eValue -> eValue.errorCode);
}
