package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum PassengerCategory {
    ADULT("Adult"), CHILD("Child"), BABY("BabyWithoutPlace");

    private final String value;

    @JsonCreator
    public static PassengerCategory fromString(String val) {
        for (PassengerCategory candidate : PassengerCategory.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum PassengerCategory", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
