package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum ReservationPlaceType {
    NO_VALUE("NoValue"), // Нет значения, не определено

    NEAR_PLAYGROUND("NearPlayground"), // У десткой площадки

    UPPER("Upper"), // Верхнее

    NOT_NEAR_TABLE("NotNearTable"), // Не у стола

    LOWER("Lower"), // Нижнее

    SIDE_LOWER_NEAR_RESTROOM("SideLowerNearRestroom"), // Боковое нижнее у туалета (плац)

    SIDE_UPPER_NEAR_RESTROOM("SideUpperNearRestroom"), // Боковое верхнее у туалета (плац)

    LAST_KUPE_LOWER("LastKupeLower"), // Последнее купе нижнее

    LAST_KUPE_UPPER("LastKupeUpper"), // Последнее купе верхнее

    MIDDLE("Middle"), // Среднее

    FOLDABLE("Foldable"), // Откидное

    WITH_PETS("WithPets"), // Для пассажира c животным

    WITH_CHILD("WithChild"), // Для пассажира c детьми

    MOTHER_AND_BABY("MotherAndBaby"), // Для матери и ребенка

    NEAR_PASSENGERS_WITH_PETS("NearPassengersWithPets"), // Рядом с местами для пассажиров с животными

    NEAR_TABLE("NearTable"), // У стола

    NEAR_TABLE_PLAYGROUND("NearTablePlayground"), // У стола рядом с детской площадкой

    SEPARATE_COMPARTMENT("SeparateCompartment"), // Отсек

    INVALIDS("Invalids"), // Для инвалидов

    INVALIDS_LOWER("InvalidsLower"), // Для инвалидов нижнее

    NEGOTIATIONS("Negotiations"), // Переговорная

    NEAR_TABLE_FORWARD("NearTableForward"), // У стола, по ходу (сид в сапсане и ласточке)

    NEAR_TABLE_BACKWARD("NearTableBackward"), // У стола, против хода (сид в сапсане и ласточке)

    NO_TABLE_FORWARD("NoTableForward"), // Не у стола, по ходу (сид в сапсане и ласточке)

    NO_TABLE_BACKWARD("NoTableBackward"), // Не у стола, против хода (сид в сапсане и ласточке)

    NO_WINDOW_FORWARD("NoWindowForward"), // Без окна, по ходу (сид в сапсане и ласточке)

    NO_WINDOW_BACKWARD("NoWindowBackward"), // Без окна, против хода (сид в сапсане и ласточке)

    SINGLE_FORWARD("SingleForward"), // Одиночное, по ходу (сид в сапсан)

    INVALIDS_UPPER("InvalidsUpper"), // Для инвалидов верхнее

    THIRD_SHELF("ThirdShelf"), // Третья полка

    NEAR_RESTROOM("NearRestroom"), // У туалета (сид в ласточке)

    FOLDABLE_NEAR_RESTROOM("FoldableNearRestroom"), // Откидное у туалета (сид в ласточке)

    NEAR_RESTROOM_AND_FORWARD("NearRestroomAndForward"), // У туалета по ходу (сид в ласточке)

    NEAR_RESTROOM_AND_BACKWARD("NearRestroomAndBackward"), // У туалета против хода (сид в ласточке)

    NO_TABLE_AND_NO_WINDOW("NoTableAndNoWindow"); // Не у стола, без окна (сид в ласточке)

    private final String value;

    @JsonCreator
    public static ReservationPlaceType fromString(String val) {
        for (ReservationPlaceType candidate : ReservationPlaceType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum ReservationPlaceType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
