package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum RoutePolicy {
    INTERNAL("Internal"),           // Внутреннее направление
    INTERNATIONAL("International"), // Внешнее направление
    FINLAND("Finland");             // Финское направление

    private final String value;

    @JsonCreator
    public static RoutePolicy fromString(String val) {
        for (RoutePolicy candidate : RoutePolicy.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum RoutePolicy", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
