package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum Sex {
    MALE("Male"), FEMALE("Female");

    private final String value;

    @JsonCreator
    public static Sex fromString(String val) {
        for (Sex candidate : Sex.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum Sex", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
