package ru.yandex.travel.train.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum TariffType {
    FULL("full"), PUPIL("pupil"), BABY("baby"), CHILD("child"), CHILD17("child_17");

    private final String value;

    @JsonCreator
    public static TariffType fromString(String val) {
        for (TariffType candidate : TariffType.values()) {
            if (candidate.getValue().equalsIgnoreCase(val)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Don't know how to map value %s to enum TariffType", val)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
