package ru.yandex.travel.train.model;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
public class TrainPassenger {
    private String firstName;
    private String lastName;
    private String patronymic;
    private Sex sex;
    private LocalDate birthday;
    private DocumentType documentType;
    private String documentNumber;
    private String citizenshipCode;
    private PassengerCategory category;
    private TariffType tariffType;
    private String tariffCode;
    private List<RailwayBonusCard> bonusCards;
    private TrainTicket ticket;
    private Integer customerId;
    private Integer partnerItemIndex;
    private Insurance insurance;
    private String phone;
    private boolean usePhoneForReservation;
    private String email;
    private boolean useEmailForReservation;
    private boolean isDiscountDenied;
    private boolean nonRefundableTariff;
    private List<Integer> requestedPlaces;

    @JsonIgnore
    public Money calculateTotalCostWithInsurance() {
        Money result = ticket.calculateTotalCost();
        if (insurance != null && insurance.getAmount() != null) {
            result = result.add(insurance.getAmount());
        }
        return result;
    }

    // TODO(syukhno): merge tariffType into tariffCode then remove
    @JsonIgnore
    public String getTariffCodeWithFallback() {
        if (tariffCode == null || tariffCode.isEmpty()) {
            return tariffType.getValue().toLowerCase();
        }
        return tariffCode;
    }
}
