package ru.yandex.travel.train.model;

import java.time.Instant;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrainReservationRequestData {
    private String banditType;
    private String stationFromCode;
    private String stationToCode;
    private int stationFromId;
    private int stationToId;
    private Instant departureTime;
    private Instant arrivalTime;
    private String trainNumber;
    private String trainTicketNumber;
    private String brandTitle;
    private String trainTitle;
    @Deprecated
    private String startSettlementTitle;
    @Deprecated
    private String endSettlementTitle;
    private String imInitialStationName;
    private String imFinalStationName;
    private AdditionalPlaceRequirements additionalPlaceRequirements = AdditionalPlaceRequirements.NO_VALUE;
    private Boolean bedding;
    private CabinGenderKind cabinGenderKind = CabinGenderKind.NO_VALUE;
    private CabinPlaceDemands cabinPlaceDemands = CabinPlaceDemands.NO_VALUE;
    private String carNumber;
    private CarStorey carStorey = CarStorey.NO_VALUE;
    private CarType carType = CarType.UNKNOWN;
    private Integer schemeId;
    private String serviceClass;
    private String internationalServiceClass;
    private boolean giveChildWithoutPlace;
    private Integer lowerPlaceQuantity;
    private Integer upperPlaceQuantity;
    private Integer placeNumberFrom;
    private Integer placeNumberTo;
    private boolean electronicRegistrationEnabled;
}
